\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{isit}[2023/03/23 Intelligent Systems and Information Technology Latex class]

%\newcommand{\medskip}{\vskip .5em}
\DeclareOption{twocolumn}{\OptionNotUsed}
%\DeclareOption{a4paper}{\setlength\paperheight {297mm}\setlength\paperwidth  {210mm}}
\DeclareOption{notitlepage}{\@titlepagefalse}
\DeclareOption{14pt}{\renewcommand\@ptsize{4}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{llncs}}
\ProcessOptions\relax
\LoadClass[a4paper,12pt]{llncs}
\RequirePackage[margin=2.5cm]{geometry}
\RequirePackage{fancyhdr}% http://ctan.org/pkg/fancyhdr

\setlength{\textwidth}{16cm}
\setlength{\textheight}{24.7cm}

\renewcommand{\headrulewidth}{0.2pt}

\renewcommand{\institute}[1]{\gdef\@institute{#1}}
\renewcommand{\andname}{and}
\renewcommand{\lastandname}{\unskip, and}

\renewcommand{\orcidID}[1]{\par {\normalfont{\small{ORCID:{#1}}}}}
\renewcommand{\figurename}{Figure}

\newcommand{\bb}{\backslash\backslash}

\newcommand{\isitdoi}[1]{\gdef\@isitdoi{#1}}

\isitdoi{}

\providecommand{\keywords}[1]%
{\def\and{\unskip{,} }%
			\par\addvspace\baselineskip
			\noindent\keywordname\enspace\ignorespaces#1}%


\def\institutename{\par
 \begingroup
%\leftmargin=1cm\relax
 \parskip=\z@
 \parindent=\z@
 \setcounter{@inst}{1}%
 \def\and{\par\vspace{0.5cm}\par\stepcounter{@inst}%
 \noindent$^{\the@inst}$\enspace\ignorespaces}%
\def\nl{\par%
 \noindent$ $\enspace$ $\enspace\ignorespaces}%
 \setbox0=\vbox{\def\thanks##1{}\@institute}%
 \ifnum\c@@inst=1\relax
   \gdef\fnnstart{0}%
 \else
   \xdef\fnnstart{\c@@inst}%
   \setcounter{@inst}{1}%
   \noindent$^{\the@inst}$\enspace
 \fi
 \ignorespaces
 \@institute\par
 \endgroup}

\renewcommand\maketitle{\newpage
\phantomsection
  \refstepcounter{chapter}%
  \stepcounter{section}%
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \setcounter{figure}{0}
  \setcounter{table}{0}
  \setcounter{equation}{0}
  \setcounter{footnote}{0}%
  \begingroup
    \parindent=\z@
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{empty}\@thanks
%
    \def\\{\unskip\ \ignorespaces}\def\inst##1{\unskip{}}%
    \def\thanks##1{\unskip{}}\def\fnmsep{\unskip}%
    \instindent=\hsize
    \advance\instindent by-\headlineindent
    \if!\the\toctitle!\addcontentsline{toc}{title}{\@title}\else
       \addcontentsline{toc}{title}{\the\toctitle}\fi
    \if@runhead
       \if!\the\titlerunning!\else
         \edef\@title{\the\titlerunning}%
       \fi
       \global\setbox\titrun=\hbox{\small\rm\unboldmath\ignorespaces\@title}%
       \ifdim\wd\titrun>\instindent
          \typeout{Title too long for running head. Please supply}%
          \typeout{a shorter form with \string\titlerunning\space prior to
                   \string\maketitle}%
          \global\setbox\titrun=\hbox{\small\rm
          Title Suppressed Due to Excessive Length}%
       \fi
       \xdef\@title{\copy\titrun}%
    \fi
%
    \if!\the\tocauthor!\relax
      {\def\and{\noexpand\protect\noexpand\and}%
       \def\inst##1{}%    added MR 2017-09-20 to remove inst numbers from the TOC
       \def\orcidID##1{}% added MR 2017-09-20 to remove ORCID ids from the TOC
      \protected@xdef\toc@uthor{\@author}}%
    \else
      \def\\{\noexpand\protect\noexpand\newline}%
      \protected@xdef\scratch{\the\tocauthor}%
      \protected@xdef\toc@uthor{\scratch}%
    \fi
    \addtocontents{toc}{\noexpand\protect\noexpand\authcount{\the\c@auco}}%
    \addcontentsline{toc}{author}{\toc@uthor}%
    \if@runhead
       \if!\the\authorrunning!
         \value{@inst}=\value{@auth}%
         \setcounter{@auth}{1}%
       \else
         \edef\@author{\the\authorrunning}%
       \fi
       \global\setbox\authrun=\hbox{\def\inst##1{}%    added MR 2017-09-20 to remove inst numbers from the runninghead
                                    \def\orcidID##1{}% added MR 2017-09-20 to remove ORCID ids from the runninghead
                                    \small\unboldmath\@author\unskip}%
       \ifdim\wd\authrun>\instindent
          \typeout{Names of authors too long for running head. Please supply}%
          \typeout{a shorter form with \string\authorrunning\space prior to
                   \string\maketitle}%
          \global\setbox\authrun=\hbox{\small\rm
          Authors Suppressed Due to Excessive Length}%
       \fi
       \xdef\@author{\copy\authrun}%
       \markboth{\@author}{\@title}%
     \fi
  \endgroup
  \setcounter{footnote}{\fnnstart}%
  \clearheadinfo}
%



\def\@maketitle{\newpage
 \markboth{}{}%
 \def\lastand{\ifnum\value{@inst}=2\relax
                 \unskip{} \andname\
              \else
                 \unskip \lastandname\
              \fi}%
 \def\and{\stepcounter{@auth}\relax
          \ifnum\value{@auth}=\value{@inst}%
             \lastand 
          \else
             \unskip, \\
          \fi}%
 %\begin{center}%
 \let\newline\\
{\lineskip .5em \bfseries
\noindent\ignorespaces
\def\and{\par\vspace{.4cm}}%
\@author\vskip1cm}
 {\small\institutename}
	\vskip1cm
 {\Large \bfseries\boldmath
  \pretolerance=10000
  \@title \par%
	\vskip .3cm
	}{\small DOI: \@isitdoi\par}\vskip .3cm
\if!\@subtitle!\else {\large \bfseries\boldmath
  \vskip -.65cm
  \pretolerance=10000
  \@subtitle \par}\vskip .8cm\fi
 \setbox0=\vbox{\setcounter{@auth}{1}\def\and{\stepcounter{@auth}}%
 \def\thanks##1{}\@author}%
 \global\value{@inst}=\value{@auth}%
 \global\value{auco}=\value{@auth}%
 \setcounter{@auth}{1}%
 %\end{center}%
 }

