\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{isit}[2024/05/10 Intelligent Systems and Information Technologies conference Latex class]

%\newcommand{\medskip}{\vskip .5em}
%\DeclareOption{twocolumn}{\OptionNotUsed}
%\DeclareOption{b5paper}
\DeclareOption{notitlepage}{\@titlepagefalse}
\DeclareOption{14pt}{\renewcommand\@ptsize{4}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{llncs}}
\ProcessOptions\relax
\LoadClass[b5paper,10pt,oneside,runningheads]{llncs}
\RequirePackage[margin=2cm]{geometry}
\RequirePackage{fancyhdr}% http://ctan.org/pkg/fancyhdr


\setlength{\paperheight}{240mm}
\setlength{\paperwidth}{170mm}

\setlength{\textheight}{190mm}
\setlength{\textwidth}{130mm}


%\setlength{\oddsidemargin}{5mm}
\setlength{\marginparwidth}{0pt}
\setlength{\marginparsep}{0pt}



\def\contentsname{Contents}

\renewcommand{\headrulewidth}{0.2pt}
\setlength{\headheight}{22.0pt}

\renewcommand{\institute}[1]{\gdef\@institute{#1}}
\renewcommand{\andname}{and}
\renewcommand{\lastandname}{\unskip, and}

\renewcommand{\orcidID}[1]{\par {\normalfont{\small{ORCID: {#1}}}}}
\renewcommand{\figurename}{Figure}

\newcommand{\bb}{\backslash\backslash}



\fancypagestyle{isit}{
    \fancyhf{}
    %\fancyhead[R]{\small \thepage \vspace{2pt}}%
    %\fancyhead[L]{\small \rightmark \vspace{2pt}}
    \fancyhead[LE,RO]{\small \thepage \vspace{2pt}}
    \fancyhead[LO]{\small \rightmark \vspace{2pt}}
    \fancyhead[CE]{\small \leftmark \vspace{2pt}}
}

\fancypagestyle{plain}{
\fancyhf{}
  \fancyhead{}
  \fancyfoot{}
  \renewcommand{\headrulewidth}{0pt}
}



% Empty pages without page numbers
\let\origdoublepage\cleardoublepage
\newcommand{\clearemptydoublepage}{%
  \clearpage
  {\pagestyle{empty}\origdoublepage}%
}


\setlength\intextsep   {4mm\@plus 2\p@ \@minus 2\p@}


\providecommand{\keywords}[1]%
{\def\and{\unskip{,} }%
			\par\addvspace\baselineskip
			\noindent\keywordname\enspace\ignorespaces#1}%


\def\institutename{\par
 \begingroup
%\leftmargin=1cm\relax
 \parskip=\z@
 \parindent=\z@
 \setcounter{@inst}{1}%
 \def\and{\par\vspace{0.5cm}\par\stepcounter{@inst}%
 \noindent$^{\the@inst}$\enspace\ignorespaces}%
\def\nl{\par%
 \noindent$ $\enspace$ $\enspace\ignorespaces}%
 \setbox0=\vbox{\def\thanks##1{}\@institute}%
 \ifnum\c@@inst=1\relax
   \gdef\fnnstart{0}%
 \else
   \xdef\fnnstart{\c@@inst}%
   \setcounter{@inst}{1}%
   \noindent$^{\the@inst}$\enspace
 \fi
 \ignorespaces
 \@institute\par
 \endgroup}
 
\pagestyle{isit}


 
\def\ps@headings{\ps@f@nch@fancyproto \def\@mkboth{\protect\markboth}
   \let\@mkboth\@gobbletwo
   \let\@oddfoot\@empty\let\@evenfoot\@empty
   %\def\@oddhead{\thispagestyle{si}}
   %\def\@evenhead{\thispagestyle{si}}

   \def\chaptermark##1{}%
   \def\sectionmark##1{}%
   \def\subsectionmark##1{}
   }
   
\def\ps@titlepage{\let\@mkboth\@gobbletwo
   \let\@oddfoot\@empty\let\@evenfoot\@empty
  % \def\@oddhead{\thispagestyle{odd}}
  % \def\@evenhead{\thispagestyle{even}}
   \def\chaptermark##1{}%
   \def\sectionmark##1{}%
   \def\subsectionmark##1{}}



\if@runhead\ps@headings\else
\ps@empty\fi

\def\@maketitle{%

    \newpage%
    %
    %\markboth{}{}%
    \vspace*{12em}%
    \def\lastand{\ifnum\value{@inst}=2\relax
                 \unskip{} \andname\
              \else
                 \unskip \lastandname\
              \fi}%
    \def\and{\stepcounter{@auth}\relax
          \ifnum\value{@auth}=\value{@inst}%
             \lastand 
          \else
             \unskip, \\
          \fi}%
    \let\newline\\
    {\lineskip .5em \bfseries
    \noindent\ignorespaces
    \def\and{\par\vspace{.4cm}}%
    \@author\vskip1cm}
     {\small\institutename}
    	\vskip1cm
     {\Large \bfseries\boldmath
      \pretolerance=10000
      \@title \par%
    	\vskip .3cm
    	}
    \if!\@subtitle!\else {\large \bfseries\boldmath
      \vskip -.65cm
      \pretolerance=10000
      \@subtitle \par}\vskip .8cm\fi
     \setbox0=\vbox{\setcounter{@auth}{1}\def\and{\stepcounter{@auth}}%
     \def\thanks##1{}\@author}%
     \global\value{@inst}=\value{@auth}%
     \global\value{auco}=\value{@auth}%
     \setcounter{@auth}{1}%
 }

